/** <!------------------------------------------------------------------------->
*
*  @file CanIf_Cfg.c
*
*  @creationDate 22 November 2024 11:42:31
*
*  @brief Generated CanIf configuration source file.
*
*  @author
*
*  @description
*
*  @copyright
*    Copyright 2024, dSPACE GmbH. All rights reserved.
*
*  @version
*
*   <hr><br>
*<!-------------------------------------------------------------------------->*/

/* -- Include directives. -- */
#include "CanIf_Internal.h"
#include "CanIf.h"
#include "PduR_CanIf.h"
#if CANIF_CANTSYN_SUPPORT == STD_ON
#include "CanTSyn_CanIf.h"
#endif
#if CANIF_J1939TP_SUPPORT == STD_ON
#include "J1939Tp_CanIf.h"
#endif
#if CANIF_CDD_SUPPORT == STD_ON
#include "CDD_CanIf.h"
#endif
#include "CanIf_Cbk.h"
#include "CanIf_Cfg_BusAccess.h"
#include "SchM_CanIf.h"

#ifdef HOST_DEBUG
// if we are compiling this for HOST Debugging we need to be aware
// of virtual bus functions.
#include <DsCanBus.h>
#endif

/*----------------------------------------------------------------------------*/
/* PROFILING SUPPORT                                                          */
/*----------------------------------------------------------------------------*/
#ifdef CANIF_ENABLE_PROFILING
#include "DsApplicationInterface.h"
static DsTProfilerSource DsCanBoard_create_PROFILER_SRC;
static DsTProfilerSource DsCanCh_create_PROFILER_SRC;
#endif


CONST(uint8, AUTOMATIC) CanIf_DevErrorDetect = STD_OFF;
CONST(uint8, AUTOMATIC) CanIf_MultipleDriverSupport = STD_OFF;
CONST(uint8, AUTOMATIC) CanIf_PublicPNSupport = STD_OFF;
CONST(uint8, AUTOMATIC) CanIf_ReadRxPduDataApi = STD_OFF;
CONST(uint8, AUTOMATIC) CanIf_ReadTxPduNotifyStatusApi = STD_OFF;
CONST(uint8, AUTOMATIC) CanIf_ReadRxPduNotifyStatusApi = STD_OFF;
CONST(uint8, AUTOMATIC) CanIf_SetDynamicTxIdApi = STD_OFF;
CONST(uint8, AUTOMATIC) CanIf_DlcCheck = STD_OFF;
CONST(uint8, AUTOMATIC) CanIf_WakeupSupport = STD_ON;
CONST(CanIfSoftwareFilterType_Type, AUTOMATIC) CanIf_SoftwareFilterType = BINARY;
CONST(uint8, AUTOMATIC) CanIf_PublicWakeupCheckValidationSupport = STD_OFF;
CONST(uint8, AUTOMATIC) CanIf_TransmitCancellation = STD_OFF;
CONST(uint8, AUTOMATIC) CanIf_PublicTxConfirmPollingSupport = STD_OFF;
CONST(uint8, AUTOMATIC) CanIf_VersionInfoApi = STD_OFF;
CONST(uint8, AUTOMATIC) CanIf_MaxNumberOfHrh = 1;
CONST(uint8, AUTOMATIC) CanIf_NumberOfCanHWUnits = 1;

VAR(CanIfControllerFlags, AUTOMATIC) g_CntrlFlags[1] = {0}; /* For C98 compatibility this array has length 1 */
static VAR(uint8, AUTOMATIC) ga_CanIfReadRxPduNotifyStatus[14] = {0}; /* For C98 compatibility this array has length 1 */
static VAR(uint8, AUTOMATIC) ga_CanIfReadTxPduNotifyStatus[15] = {0}; /* For C98 compatibility this array has length 1 */
STATIC VAR(uint8, AUTOMATIC) ga_CanIfRxPduDataBuffer[1] = {0}; /* For C98 compatibility this array has length 1 */
STATIC VAR(uint32, AUTOMATIC) ga_CanIfDynamicTxPduCanIdArray[1] = {0}; /* For C98 compatibility this array has length 1 */
STATIC VAR(CanIf_RxIndicationMetaDataType, AUTOMATIC) ga_CanIfRxMetaData[1] = {0}; /* For C98 compatibility this array has length 1 */
STATIC VAR(CanIf_RxIndicationMetaDataType, AUTOMATIC) ga_CanIfRxInterruptMetaData[1] = {0}; /* For C98 compatibility this array has length 1 */

static CanIfTxPduConfig TxPduConfig[] = {
    /* ThermalCANcomplete */
    { /* 0 */
        CanIf_ThermalCANcomplete_AngVel_Compressor_FrameTrig, /* CanIf Pdu Id */
        0, /* 0x00000000 CAN Id */
        CANIF_DLC_STANDARD, /* DLC TYPE */
        2, /* DLC */
        CANIF_PDU_TYPE_STATIC,
        0, /* Dynamic PDU index */
        FALSE, /* PduNotifyStatus */
        STANDARD_CAN, /* CAN Id Type */
        FALSE, /* GetTxPduPnFilterPdu */
        CANIF_PDUR, /* TX user */
        PduR_CanIfTxConfirmation, /* User confirmation */
        0, /* CanIfCanTxPduHthRef */
        0, /* PduIdRef */
        1, /* Queue size */
        0x00 /* Unused bit pattern */
    },
    { /* 1 */
        CanIf_ThermalCANcomplete_EPower_Compressor_FrameTrig, /* CanIf Pdu Id */
        9, /* 0x00000009 CAN Id */
        CANIF_DLC_STANDARD, /* DLC TYPE */
        2, /* DLC */
        CANIF_PDU_TYPE_STATIC,
        0, /* Dynamic PDU index */
        FALSE, /* PduNotifyStatus */
        STANDARD_CAN, /* CAN Id Type */
        FALSE, /* GetTxPduPnFilterPdu */
        CANIF_PDUR, /* TX user */
        PduR_CanIfTxConfirmation, /* User confirmation */
        1, /* CanIfCanTxPduHthRef */
        0, /* PduIdRef */
        1, /* Queue size */
        0x00 /* Unused bit pattern */
    },
    { /* 2 */
        CanIf_ThermalCANcomplete_i_battery_FrameTrig, /* CanIf Pdu Id */
        10, /* 0x0000000A CAN Id */
        CANIF_DLC_STANDARD, /* DLC TYPE */
        2, /* DLC */
        CANIF_PDU_TYPE_STATIC,
        0, /* Dynamic PDU index */
        FALSE, /* PduNotifyStatus */
        STANDARD_CAN, /* CAN Id Type */
        FALSE, /* GetTxPduPnFilterPdu */
        CANIF_PDUR, /* TX user */
        PduR_CanIfTxConfirmation, /* User confirmation */
        2, /* CanIfCanTxPduHthRef */
        0, /* PduIdRef */
        1, /* Queue size */
        0x00 /* Unused bit pattern */
    },
    { /* 3 */
        CanIf_ThermalCANcomplete_p_chiller_FrameTrig, /* CanIf Pdu Id */
        12, /* 0x0000000C CAN Id */
        CANIF_DLC_STANDARD, /* DLC TYPE */
        1, /* DLC */
        CANIF_PDU_TYPE_STATIC,
        0, /* Dynamic PDU index */
        FALSE, /* PduNotifyStatus */
        STANDARD_CAN, /* CAN Id Type */
        FALSE, /* GetTxPduPnFilterPdu */
        CANIF_PDUR, /* TX user */
        PduR_CanIfTxConfirmation, /* User confirmation */
        3, /* CanIfCanTxPduHthRef */
        0, /* PduIdRef */
        1, /* Queue size */
        0x00 /* Unused bit pattern */
    },
    { /* 4 */
        CanIf_ThermalCANcomplete_p_cond_FrameTrig, /* CanIf Pdu Id */
        13, /* 0x0000000D CAN Id */
        CANIF_DLC_STANDARD, /* DLC TYPE */
        1, /* DLC */
        CANIF_PDU_TYPE_STATIC,
        0, /* Dynamic PDU index */
        FALSE, /* PduNotifyStatus */
        STANDARD_CAN, /* CAN Id Type */
        FALSE, /* GetTxPduPnFilterPdu */
        CANIF_PDUR, /* TX user */
        PduR_CanIfTxConfirmation, /* User confirmation */
        4, /* CanIfCanTxPduHthRef */
        0, /* PduIdRef */
        1, /* Queue size */
        0x00 /* Unused bit pattern */
    },
    { /* 5 */
        CanIf_ThermalCANcomplete_PJoule_battery_FrameTrig, /* CanIf Pdu Id */
        14, /* 0x0000000E CAN Id */
        CANIF_DLC_STANDARD, /* DLC TYPE */
        2, /* DLC */
        CANIF_PDU_TYPE_STATIC,
        0, /* Dynamic PDU index */
        FALSE, /* PduNotifyStatus */
        STANDARD_CAN, /* CAN Id Type */
        FALSE, /* GetTxPduPnFilterPdu */
        CANIF_PDUR, /* TX user */
        PduR_CanIfTxConfirmation, /* User confirmation */
        5, /* CanIfCanTxPduHthRef */
        0, /* PduIdRef */
        1, /* Queue size */
        0x00 /* Unused bit pattern */
    },
    { /* 6 */
        CanIf_ThermalCANcomplete_T_battery1_FrameTrig, /* CanIf Pdu Id */
        19, /* 0x00000013 CAN Id */
        CANIF_DLC_STANDARD, /* DLC TYPE */
        2, /* DLC */
        CANIF_PDU_TYPE_STATIC,
        0, /* Dynamic PDU index */
        FALSE, /* PduNotifyStatus */
        STANDARD_CAN, /* CAN Id Type */
        FALSE, /* GetTxPduPnFilterPdu */
        CANIF_PDUR, /* TX user */
        PduR_CanIfTxConfirmation, /* User confirmation */
        6, /* CanIfCanTxPduHthRef */
        0, /* PduIdRef */
        1, /* Queue size */
        0x00 /* Unused bit pattern */
    },
    { /* 7 */
        CanIf_ThermalCANcomplete_T_battery2_FrameTrig, /* CanIf Pdu Id */
        20, /* 0x00000014 CAN Id */
        CANIF_DLC_STANDARD, /* DLC TYPE */
        2, /* DLC */
        CANIF_PDU_TYPE_STATIC,
        0, /* Dynamic PDU index */
        FALSE, /* PduNotifyStatus */
        STANDARD_CAN, /* CAN Id Type */
        FALSE, /* GetTxPduPnFilterPdu */
        CANIF_PDUR, /* TX user */
        PduR_CanIfTxConfirmation, /* User confirmation */
        7, /* CanIfCanTxPduHthRef */
        0, /* PduIdRef */
        1, /* Queue size */
        0x00 /* Unused bit pattern */
    },
    { /* 8 */
        CanIf_ThermalCANcomplete_T_battery3_FrameTrig, /* CanIf Pdu Id */
        21, /* 0x00000015 CAN Id */
        CANIF_DLC_STANDARD, /* DLC TYPE */
        2, /* DLC */
        CANIF_PDU_TYPE_STATIC,
        0, /* Dynamic PDU index */
        FALSE, /* PduNotifyStatus */
        STANDARD_CAN, /* CAN Id Type */
        FALSE, /* GetTxPduPnFilterPdu */
        CANIF_PDUR, /* TX user */
        PduR_CanIfTxConfirmation, /* User confirmation */
        8, /* CanIfCanTxPduHthRef */
        0, /* PduIdRef */
        1, /* Queue size */
        0x00 /* Unused bit pattern */
    },
    { /* 9 */
        CanIf_ThermalCANcomplete_T_battery4_FrameTrig, /* CanIf Pdu Id */
        22, /* 0x00000016 CAN Id */
        CANIF_DLC_STANDARD, /* DLC TYPE */
        2, /* DLC */
        CANIF_PDU_TYPE_STATIC,
        0, /* Dynamic PDU index */
        FALSE, /* PduNotifyStatus */
        STANDARD_CAN, /* CAN Id Type */
        FALSE, /* GetTxPduPnFilterPdu */
        CANIF_PDUR, /* TX user */
        PduR_CanIfTxConfirmation, /* User confirmation */
        9, /* CanIfCanTxPduHthRef */
        0, /* PduIdRef */
        1, /* Queue size */
        0x00 /* Unused bit pattern */
    },
    { /* 10 */
        CanIf_ThermalCANcomplete_T_coolant_battery_in_FrameTrig, /* CanIf Pdu Id */
        23, /* 0x00000017 CAN Id */
        CANIF_DLC_STANDARD, /* DLC TYPE */
        2, /* DLC */
        CANIF_PDU_TYPE_STATIC,
        0, /* Dynamic PDU index */
        FALSE, /* PduNotifyStatus */
        STANDARD_CAN, /* CAN Id Type */
        FALSE, /* GetTxPduPnFilterPdu */
        CANIF_PDUR, /* TX user */
        PduR_CanIfTxConfirmation, /* User confirmation */
        10, /* CanIfCanTxPduHthRef */
        0, /* PduIdRef */
        1, /* Queue size */
        0x00 /* Unused bit pattern */
    },
    { /* 11 */
        CanIf_ThermalCANcomplete_T_coolant_inverter_out_FrameTrig, /* CanIf Pdu Id */
        24, /* 0x00000018 CAN Id */
        CANIF_DLC_STANDARD, /* DLC TYPE */
        2, /* DLC */
        CANIF_PDU_TYPE_STATIC,
        0, /* Dynamic PDU index */
        FALSE, /* PduNotifyStatus */
        STANDARD_CAN, /* CAN Id Type */
        FALSE, /* GetTxPduPnFilterPdu */
        CANIF_PDUR, /* TX user */
        PduR_CanIfTxConfirmation, /* User confirmation */
        11, /* CanIfCanTxPduHthRef */
        0, /* PduIdRef */
        1, /* Queue size */
        0x00 /* Unused bit pattern */
    },
    { /* 12 */
        CanIf_ThermalCANcomplete_T_inverter_FrameTrig, /* CanIf Pdu Id */
        25, /* 0x00000019 CAN Id */
        CANIF_DLC_STANDARD, /* DLC TYPE */
        2, /* DLC */
        CANIF_PDU_TYPE_STATIC,
        0, /* Dynamic PDU index */
        FALSE, /* PduNotifyStatus */
        STANDARD_CAN, /* CAN Id Type */
        FALSE, /* GetTxPduPnFilterPdu */
        CANIF_PDUR, /* TX user */
        PduR_CanIfTxConfirmation, /* User confirmation */
        12, /* CanIfCanTxPduHthRef */
        0, /* PduIdRef */
        1, /* Queue size */
        0x00 /* Unused bit pattern */
    },
    { /* 13 */
        CanIf_ThermalCANcomplete_T_motor_FrameTrig, /* CanIf Pdu Id */
        26, /* 0x0000001A CAN Id */
        CANIF_DLC_STANDARD, /* DLC TYPE */
        2, /* DLC */
        CANIF_PDU_TYPE_STATIC,
        0, /* Dynamic PDU index */
        FALSE, /* PduNotifyStatus */
        STANDARD_CAN, /* CAN Id Type */
        FALSE, /* GetTxPduPnFilterPdu */
        CANIF_PDUR, /* TX user */
        PduR_CanIfTxConfirmation, /* User confirmation */
        13, /* CanIfCanTxPduHthRef */
        0, /* PduIdRef */
        1, /* Queue size */
        0x00 /* Unused bit pattern */
    },
    { /* 14 */
        CanIf_ThermalCANcomplete_Torque_Compressor_FrameTrig, /* CanIf Pdu Id */
        27, /* 0x0000001B CAN Id */
        CANIF_DLC_STANDARD, /* DLC TYPE */
        2, /* DLC */
        CANIF_PDU_TYPE_STATIC,
        0, /* Dynamic PDU index */
        FALSE, /* PduNotifyStatus */
        STANDARD_CAN, /* CAN Id Type */
        FALSE, /* GetTxPduPnFilterPdu */
        CANIF_PDUR, /* TX user */
        PduR_CanIfTxConfirmation, /* User confirmation */
        14, /* CanIfCanTxPduHthRef */
        0, /* PduIdRef */
        1, /* Queue size */
        0x00 /* Unused bit pattern */
    },
};

static CanIfHthConfig HthConfig[] = {
    /* ThermalCANcomplete */
    {
            FULL_CAN, /* CanIfHthType */
            0,        /* CanIfCanControllerIdRef */
            0         /* CanIfHthIdSymRef */
    },
    {
            FULL_CAN, /* CanIfHthType */
            0,        /* CanIfCanControllerIdRef */
            0         /* CanIfHthIdSymRef */
    },
    {
            FULL_CAN, /* CanIfHthType */
            0,        /* CanIfCanControllerIdRef */
            0         /* CanIfHthIdSymRef */
    },
    {
            FULL_CAN, /* CanIfHthType */
            0,        /* CanIfCanControllerIdRef */
            0         /* CanIfHthIdSymRef */
    },
    {
            FULL_CAN, /* CanIfHthType */
            0,        /* CanIfCanControllerIdRef */
            0         /* CanIfHthIdSymRef */
    },
    {
            FULL_CAN, /* CanIfHthType */
            0,        /* CanIfCanControllerIdRef */
            0         /* CanIfHthIdSymRef */
    },
    {
            FULL_CAN, /* CanIfHthType */
            0,        /* CanIfCanControllerIdRef */
            0         /* CanIfHthIdSymRef */
    },
    {
            FULL_CAN, /* CanIfHthType */
            0,        /* CanIfCanControllerIdRef */
            0         /* CanIfHthIdSymRef */
    },
    {
            FULL_CAN, /* CanIfHthType */
            0,        /* CanIfCanControllerIdRef */
            0         /* CanIfHthIdSymRef */
    },
    {
            FULL_CAN, /* CanIfHthType */
            0,        /* CanIfCanControllerIdRef */
            0         /* CanIfHthIdSymRef */
    },
    {
            FULL_CAN, /* CanIfHthType */
            0,        /* CanIfCanControllerIdRef */
            0         /* CanIfHthIdSymRef */
    },
    {
            FULL_CAN, /* CanIfHthType */
            0,        /* CanIfCanControllerIdRef */
            0         /* CanIfHthIdSymRef */
    },
    {
            FULL_CAN, /* CanIfHthType */
            0,        /* CanIfCanControllerIdRef */
            0         /* CanIfHthIdSymRef */
    },
    {
            FULL_CAN, /* CanIfHthType */
            0,        /* CanIfCanControllerIdRef */
            0         /* CanIfHthIdSymRef */
    },
    {
            FULL_CAN, /* CanIfHthType */
            0,        /* CanIfCanControllerIdRef */
            0         /* CanIfHthIdSymRef */
    },
};

static VAR(CanIfRxPduConfig, AUTOMATIC) RxPduConfig[] =
{
    /* ThermalCANcomplete */
    { /* 0 */
        CanIf_ThermalCANcomplete_cmd_battery_pump_FrameTrig, /* CanIf Pdu Id */
        1, /* 0x00000001 CAN Id */
        1, /* DLC */
        FALSE, /* CanIfReadRxPduData */
        FALSE, /* CanIfReadRxPduNotifyStatus */
        STANDARD_CAN, /* CAN Id Type */
        CANIF_PDUR, /* RX user */
        PduR_CanIfRxIndication, /* User RX indication */
        0, /* CanIfCanRxPduHrhRef */
        PDUR_RX_cmd_battery_pump_10692_11337_CanIf_Com, /* PduIdRef */
        0, /* RxPduCanIdRange */
        0, /* CanIfRxPduDataBufferInd */
        NULL_PTR, /* RX Interrupt function pointer */
        0, /*Rx Interrupt State Manager index */
    },
    { /* 1 */
        CanIf_ThermalCANcomplete_cmd_chiller_bypass_FrameTrig, /* CanIf Pdu Id */
        2, /* 0x00000002 CAN Id */
        1, /* DLC */
        FALSE, /* CanIfReadRxPduData */
        FALSE, /* CanIfReadRxPduNotifyStatus */
        STANDARD_CAN, /* CAN Id Type */
        CANIF_PDUR, /* RX user */
        PduR_CanIfRxIndication, /* User RX indication */
        0, /* CanIfCanRxPduHrhRef */
        PDUR_RX_cmd_chiller_bypass_10692_11337_CanIf_Com, /* PduIdRef */
        0, /* RxPduCanIdRange */
        0, /* CanIfRxPduDataBufferInd */
        NULL_PTR, /* RX Interrupt function pointer */
        0, /*Rx Interrupt State Manager index */
    },
    { /* 2 */
        CanIf_ThermalCANcomplete_cmd_comp_FrameTrig, /* CanIf Pdu Id */
        3, /* 0x00000003 CAN Id */
        2, /* DLC */
        FALSE, /* CanIfReadRxPduData */
        FALSE, /* CanIfReadRxPduNotifyStatus */
        STANDARD_CAN, /* CAN Id Type */
        CANIF_PDUR, /* RX user */
        PduR_CanIfRxIndication, /* User RX indication */
        0, /* CanIfCanRxPduHrhRef */
        PDUR_RX_cmd_comp_10692_11337_CanIf_Com, /* PduIdRef */
        0, /* RxPduCanIdRange */
        0, /* CanIfRxPduDataBufferInd */
        NULL_PTR, /* RX Interrupt function pointer */
        0, /*Rx Interrupt State Manager index */
    },
    { /* 3 */
        CanIf_ThermalCANcomplete_cmd_fan_FrameTrig, /* CanIf Pdu Id */
        4, /* 0x00000004 CAN Id */
        8, /* DLC */
        FALSE, /* CanIfReadRxPduData */
        FALSE, /* CanIfReadRxPduNotifyStatus */
        STANDARD_CAN, /* CAN Id Type */
        CANIF_PDUR, /* RX user */
        PduR_CanIfRxIndication, /* User RX indication */
        0, /* CanIfCanRxPduHrhRef */
        PDUR_RX_cmd_fan_10692_11337_CanIf_Com, /* PduIdRef */
        0, /* RxPduCanIdRange */
        0, /* CanIfRxPduDataBufferInd */
        NULL_PTR, /* RX Interrupt function pointer */
        0, /*Rx Interrupt State Manager index */
    },
    { /* 4 */
        CanIf_ThermalCANcomplete_cmd_heater_FrameTrig, /* CanIf Pdu Id */
        5, /* 0x00000005 CAN Id */
        1, /* DLC */
        FALSE, /* CanIfReadRxPduData */
        FALSE, /* CanIfReadRxPduNotifyStatus */
        STANDARD_CAN, /* CAN Id Type */
        CANIF_PDUR, /* RX user */
        PduR_CanIfRxIndication, /* User RX indication */
        0, /* CanIfCanRxPduHrhRef */
        PDUR_RX_cmd_heater_10692_11337_CanIf_Com, /* PduIdRef */
        0, /* RxPduCanIdRange */
        0, /* CanIfRxPduDataBufferInd */
        NULL_PTR, /* RX Interrupt function pointer */
        0, /*Rx Interrupt State Manager index */
    },
    { /* 5 */
        CanIf_ThermalCANcomplete_cmd_motor_pump_FrameTrig, /* CanIf Pdu Id */
        6, /* 0x00000006 CAN Id */
        1, /* DLC */
        FALSE, /* CanIfReadRxPduData */
        FALSE, /* CanIfReadRxPduNotifyStatus */
        STANDARD_CAN, /* CAN Id Type */
        CANIF_PDUR, /* RX user */
        PduR_CanIfRxIndication, /* User RX indication */
        0, /* CanIfCanRxPduHrhRef */
        PDUR_RX_cmd_motor_pump_10692_11337_CanIf_Com, /* PduIdRef */
        0, /* RxPduCanIdRange */
        0, /* CanIfRxPduDataBufferInd */
        NULL_PTR, /* RX Interrupt function pointer */
        0, /*Rx Interrupt State Manager index */
    },
    { /* 6 */
        CanIf_ThermalCANcomplete_cmd_parallel_serial_FrameTrig, /* CanIf Pdu Id */
        7, /* 0x00000007 CAN Id */
        1, /* DLC */
        FALSE, /* CanIfReadRxPduData */
        FALSE, /* CanIfReadRxPduNotifyStatus */
        STANDARD_CAN, /* CAN Id Type */
        CANIF_PDUR, /* RX user */
        PduR_CanIfRxIndication, /* User RX indication */
        0, /* CanIfCanRxPduHrhRef */
        PDUR_RX_cmd_parallel_serial_10692_11337_CanIf_Com, /* PduIdRef */
        0, /* RxPduCanIdRange */
        0, /* CanIfRxPduDataBufferInd */
        NULL_PTR, /* RX Interrupt function pointer */
        0, /*Rx Interrupt State Manager index */
    },
    { /* 7 */
        CanIf_ThermalCANcomplete_cmd_rad_bypass_FrameTrig, /* CanIf Pdu Id */
        8, /* 0x00000008 CAN Id */
        1, /* DLC */
        FALSE, /* CanIfReadRxPduData */
        FALSE, /* CanIfReadRxPduNotifyStatus */
        STANDARD_CAN, /* CAN Id Type */
        CANIF_PDUR, /* RX user */
        PduR_CanIfRxIndication, /* User RX indication */
        0, /* CanIfCanRxPduHrhRef */
        PDUR_RX_cmd_rad_bypass_10692_11337_CanIf_Com, /* PduIdRef */
        0, /* RxPduCanIdRange */
        0, /* CanIfRxPduDataBufferInd */
        NULL_PTR, /* RX Interrupt function pointer */
        0, /*Rx Interrupt State Manager index */
    },
    { /* 8 */
        CanIf_ThermalCANcomplete_I_traction_FrameTrig, /* CanIf Pdu Id */
        11, /* 0x0000000B CAN Id */
        2, /* DLC */
        FALSE, /* CanIfReadRxPduData */
        FALSE, /* CanIfReadRxPduNotifyStatus */
        STANDARD_CAN, /* CAN Id Type */
        CANIF_PDUR, /* RX user */
        PduR_CanIfRxIndication, /* User RX indication */
        0, /* CanIfCanRxPduHrhRef */
        PDUR_RX_I_traction_10692_11337_CanIf_Com, /* PduIdRef */
        0, /* RxPduCanIdRange */
        0, /* CanIfRxPduDataBufferInd */
        NULL_PTR, /* RX Interrupt function pointer */
        0, /*Rx Interrupt State Manager index */
    },
    { /* 9 */
        CanIf_ThermalCANcomplete_Q_charger_FrameTrig, /* CanIf Pdu Id */
        15, /* 0x0000000F CAN Id */
        2, /* DLC */
        FALSE, /* CanIfReadRxPduData */
        FALSE, /* CanIfReadRxPduNotifyStatus */
        STANDARD_CAN, /* CAN Id Type */
        CANIF_PDUR, /* RX user */
        PduR_CanIfRxIndication, /* User RX indication */
        0, /* CanIfCanRxPduHrhRef */
        PDUR_RX_Q_charger_10692_11337_CanIf_Com, /* PduIdRef */
        0, /* RxPduCanIdRange */
        0, /* CanIfRxPduDataBufferInd */
        NULL_PTR, /* RX Interrupt function pointer */
        0, /*Rx Interrupt State Manager index */
    },
    { /* 10 */
        CanIf_ThermalCANcomplete_Q_dcdc_FrameTrig, /* CanIf Pdu Id */
        16, /* 0x00000010 CAN Id */
        2, /* DLC */
        FALSE, /* CanIfReadRxPduData */
        FALSE, /* CanIfReadRxPduNotifyStatus */
        STANDARD_CAN, /* CAN Id Type */
        CANIF_PDUR, /* RX user */
        PduR_CanIfRxIndication, /* User RX indication */
        0, /* CanIfCanRxPduHrhRef */
        PDUR_RX_Q_dcdc_10692_11337_CanIf_Com, /* PduIdRef */
        0, /* RxPduCanIdRange */
        0, /* CanIfRxPduDataBufferInd */
        NULL_PTR, /* RX Interrupt function pointer */
        0, /*Rx Interrupt State Manager index */
    },
    { /* 11 */
        CanIf_ThermalCANcomplete_Q_inverter_FrameTrig, /* CanIf Pdu Id */
        17, /* 0x00000011 CAN Id */
        2, /* DLC */
        FALSE, /* CanIfReadRxPduData */
        FALSE, /* CanIfReadRxPduNotifyStatus */
        STANDARD_CAN, /* CAN Id Type */
        CANIF_PDUR, /* RX user */
        PduR_CanIfRxIndication, /* User RX indication */
        0, /* CanIfCanRxPduHrhRef */
        PDUR_RX_Q_inverter_10692_11337_CanIf_Com, /* PduIdRef */
        0, /* RxPduCanIdRange */
        0, /* CanIfRxPduDataBufferInd */
        NULL_PTR, /* RX Interrupt function pointer */
        0, /*Rx Interrupt State Manager index */
    },
    { /* 12 */
        CanIf_ThermalCANcomplete_Q_motor_FrameTrig, /* CanIf Pdu Id */
        18, /* 0x00000012 CAN Id */
        2, /* DLC */
        FALSE, /* CanIfReadRxPduData */
        FALSE, /* CanIfReadRxPduNotifyStatus */
        STANDARD_CAN, /* CAN Id Type */
        CANIF_PDUR, /* RX user */
        PduR_CanIfRxIndication, /* User RX indication */
        0, /* CanIfCanRxPduHrhRef */
        PDUR_RX_Q_motor_10692_11337_CanIf_Com, /* PduIdRef */
        0, /* RxPduCanIdRange */
        0, /* CanIfRxPduDataBufferInd */
        NULL_PTR, /* RX Interrupt function pointer */
        0, /*Rx Interrupt State Manager index */
    },
    { /* 13 */
        CanIf_ThermalCANcomplete_v_vehicle_FrameTrig, /* CanIf Pdu Id */
        28, /* 0x0000001C CAN Id */
        2, /* DLC */
        FALSE, /* CanIfReadRxPduData */
        FALSE, /* CanIfReadRxPduNotifyStatus */
        STANDARD_CAN, /* CAN Id Type */
        CANIF_PDUR, /* RX user */
        PduR_CanIfRxIndication, /* User RX indication */
        0, /* CanIfCanRxPduHrhRef */
        PDUR_RX_v_vehicle_10692_11337_CanIf_Com, /* PduIdRef */
        0, /* RxPduCanIdRange */
        0, /* CanIfRxPduDataBufferInd */
        NULL_PTR, /* RX Interrupt function pointer */
        0, /*Rx Interrupt State Manager index */
    },
};

UNUSED static VAR(CanIfHrhRangeConfig, AUTOMATIC) HrhRangeConfig0[1] = { 0 };  /* For C98 compatibility this array has length 1 */

static VAR(CanIfHrhConfig, AUTOMATIC) HrhConfig[] = {
    { /* ThermalCANcomplete */
        0, /* CanIfHrhId */
        BASIC_CAN,       /* CanIfHrhType */
        FALSE,           /* CanIfSoftwareFilterHrh */
        0,               /* CanIfCanControllerHrhIdRef */
        0,               /* CanIfHrhIdSymRef */
        HrhRangeConfig0, /* HrhRangeConfig */
        0                /* CanIfNumberofHrhRange */
    },
};

static CanIfInitHohConfig InitHohConfig[] =
{
    {
            0,            /* RefConfigSet */
            HrhConfig,
            HthConfig
    }
};

static CanIfInitConfiguration InitConfiguration[] =
{
    {
            14, /* Number of CAN RX PDU IDs */
            15, /* Number of CAN TX PDU IDs */
            0, /* Number of dynamic CAN TX PDU IDs*/
            InitHohConfig,
            RxPduConfig,
            TxPduConfig
    }
};

static CanIfDriverConfig DriverConfig[1] =
{
    {
            FALSE, /* CanIfBusoffNotification */
            FALSE, /* CanIfReceiveIndication */
            FALSE, /* CanIfTransmitCancellation */
            FALSE, /* CanIfTxConfirmation */
            FALSE, /* CanIfWakeupNotification */
            0,     /* CanIfDriverNameRef */
            0      /* InitHohConfigRef */
    }
};

static CanIfDispatchConfig DispatchConfig[1] =
{
    {
            0,          /* CanIfDispatchUserCtrlBusOffName */
            UL_NONE,    /* DispatchUserCtrlBusOffUL */
            0,          /* CanIfDispatchUserValidateWakeupEventName */
            UL_NONE,    /* CanIfDispatchUserValidateWakeupEventUL */
            CanIf_TransmitFunction, /* CanIfDispatchTransmit */
            CanIf_RxIndication      /* CanIfDispatchRxIndication */
    }
};

static CanIfControllerConfig ControllerConfig[CHANNEL_ADDRESS_COUNT] =
{
     {
            FALSE, /* CanIfWakeupSupport */
            0,     /* CanIfControllerIdRef */
            0,     /* CanIfDriverNameRef */
            TRUE, /* CanIfRxObjectNeeded */
            TRUE,     /* CanIf_ControllerEnabledState */
            2,     /* Index in StateManager to handle ComControllerEnable state */
            0,    /* Index in StateManager for used credit counter */
            (DsTCanBoard)0 /* CanBoard */
    },
};

static CanIf_ConfigType ga_CanIfConfig[1] =
{
    {       /* ga_CanIfConfig */
            ControllerConfig,
            DispatchConfig,
            DriverConfig,
            InitConfiguration,
            ga_CanIfRxPduDataBuffer,
            ga_CanIfDynamicTxPduCanIdArray,
            ga_CanIfReadRxPduNotifyStatus,
            ga_CanIfReadTxPduNotifyStatus,
            3,
            ga_CanIfRxMetaData,
            ga_CanIfRxInterruptMetaData,
    }
};

UNUSED static uint32 gClusterId[CHANNEL_ADDRESS_COUNT] = { 1 };

void
CanIf_InitDefaultConfig(void)
{
    uint8 i;

    for (i = 0; i < CHANNEL_ADDRESS_COUNT; i++)
    {
      DsTCanBoard CanBoard;
      DsTCanCh    CanChannel;
      
#ifdef CANIF_ENABLE_PROFILING	
      dsProfilerWriteEvent(DsCanBoard_create_PROFILER_SRC, UserTimespanStart, 0u, i);
#endif
      DsCanBoard_create(&CanBoard, *gp_CanIf_ChannelAddress[i]);
#ifdef CANIF_ENABLE_PROFILING
      dsProfilerWriteEvent(DsCanBoard_create_PROFILER_SRC, UserTimespanEnd, 0u, i);
#endif
      
#ifdef CANIF_ENABLE_PROFILING	
      dsProfilerWriteEvent(DsCanCh_create_PROFILER_SRC, UserTimespanStart, 0u, i);
#endif
      DsCanCh_create(&CanChannel, CanBoard, *gp_CanIf_ChannelAddress[i]);
#ifdef CANIF_ENABLE_PROFILING
      dsProfilerWriteEvent(DsCanCh_create_PROFILER_SRC, UserTimespanEnd, 0u, i);
#endif
      
#if defined(HOST_DEBUG)
      {
        DsTCanBus pBus;
        DsCanBus_create(&pBus, gClusterId[i]);
        DsCanBus_connectChannel(pBus, CanChannel);
      }
#endif

      ga_CanIfConfig->ControllerConfig[i].CanBoard = CanBoard;
      ga_CanIfConfig->ControllerConfig[i].CanIfControllerIdRef = CanChannel;
    }
}

void
CanIf_Init(const void * ConfigStruct)
{
    INTENDED_UNREFERENCED_PARAMETER(ConfigStruct);
}

STATIC boolean doFirstStepInitialization = TRUE;

extern void* Bus_Configuration__1__11337_CanIfHthIdSymRef[1];

void CanIf_VariableInitialize(void)
{
    uint8 controllerState;

    /* do other modules need CanIf to be initialized earlier? */
    CanIf_InitFunction((const void *) ga_CanIfConfig);

    if (doFirstStepInitialization)
    {
        for (PduIdType Count = 0; Count < InitConfiguration[0].CanIfNumberOfCanTxPduIds; Count++)
        {
            if (HthConfig[Count].CanIfCanControllerIdRef != 0) continue;
            uint8 pduF = (uint8)(TxPduConfig[Count].CanIfCanTxPduIdCanId >> 16);
            if (!(TxPduConfig[Count].CanIfTxUserType == CANIF_J1939TP && (pduF == 0xEB || pduF == 0xEC)) &&
                !(TxPduConfig[Count].CanIfTxUserType == CANIF_CANTSYN))
            {
                HthConfig[Count].CanIfHthIdSymRef = Bus_Configuration__1__11337_CanIfHthIdSymRef[0];
                TxPduConfig[Count].QueueSize = 200;
            }
        }
        CanIf_InitController(0, 0);
#ifdef CANIF_ENABLE_PROFILING
        DsCanBoard_create_PROFILER_SRC = dsProfilerCreateSource(MACRO_NAME_TOSTR(ECU_ID)"_DsCanBoard_create");
        DsCanCh_create_PROFILER_SRC = dsProfilerCreateSource(MACRO_NAME_TOSTR(ECU_ID)"_DsCanCh_create");
#endif
    }
    CanIf_SetControllerMode(0, CANIF_CS_STARTED);
    CanIf_SetPduMode(0, CANIF_SET_RX_ONLINE);
    CanIf_SetPduMode(0, CANIF_SET_TX_ONLINE);/**/
    controllerState = TRUE;
    /* The Controller state is set to the default state depending on first or on every application start */
    StateManager_SetState_Mutex(2,controllerState);


    doFirstStepInitialization = FALSE;
}

/* [EOF] */
